// ButtonEx.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ib.h"
#include "ButtonObj.h"

#include "ButtonEx.h"
#include "IBView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CStatusBar *g_pStBar;
/////////////////////////////////////////////////////////////////////////////
// CButtonEx

CButtonEx::CButtonEx()
:m_DefaultColor( ::GetSysColor( COLOR_BTNFACE))
{
	m_SelectedColor = m_DefaultColor;
}

CButtonEx::~CButtonEx()
{
}


BEGIN_MESSAGE_MAP(CButtonEx, CButton)
	//{{AFX_MSG_MAP(CButtonEx)
	ON_CONTROL_REFLECT(BN_CLICKED, OnClicked)
	ON_CONTROL_REFLECT(BN_DOUBLECLICKED, OnDoubleclicked)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CButtonEx bZ[W nh

void CButtonEx::OnClicked() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CString strCaption;
	m_pButtonObj->GetButtonCaption(strCaption);
	TRACE("%sNbN܂\n",strCaption);
	
	CString strXMLPath = m_pButtonObj->GetXMLPath();
	g_pStBar->SetPaneText(g_pStBar->CommandToIndex(ID_INDICATOR_PATH),strXMLPath);

	CIBView *pView = (CIBView*)GetOwner();
	pView->SetSelectedItem((CObjItem*)m_pButtonObj);
//	SetColor(0xaaaaaa);
}


void CButtonEx::OnDoubleclicked() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CString strXMLPath = m_pButtonObj->GetXMLPath();
	g_pStBar->SetPaneText(g_pStBar->CommandToIndex(ID_INDICATOR_PATH),strXMLPath);

	CIBView *pView = (CIBView*)GetOwner();
	pView->SetSelectedItem((CObjItem*)m_pButtonObj,TRUE);	
}

void CButtonEx::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: w肳ꂽACe`悷邽߂̃R[hǉĂ
	// DrawItemStruct\̂FromHandle擾
    CDC * dc = CDC::FromHandle(lpDrawItemStruct->hDC);

    // fBoCXReLXgۑ
    dc->SaveDC();

    // ĕ`悷̈擾
    CRect rc = lpDrawItemStruct->rcItem;

    // w肳ꂽ̐Fݒ肷
    // ł͔ɐݒ肵܂
    dc->SetTextColor( RGB( 0,0,0));

    // `擮삪Ŝ̍ĕ`́A
    // IԂωꍇ
    if( lpDrawItemStruct->itemAction & ( ODA_DRAWENTIRE | ODA_SELECT ))
    {
        // DrawFrameControl()\bh̃tOݒ
        // Rg[̋Ȇ傫AA
        // ĂȂ{^
        UINT flg = DFCS_ADJUSTRECT | DFCS_BUTTONPUSH;

        // Rg[̏ԂIꂽԂ̏ꍇ
        if( lpDrawItemStruct->itemState & ODS_SELECTED )
        {
            // tOɉꂽ{^̃tOǉ
            flg |= DFCS_PUSHED;
        }

        // Rg[ĕ`悷͈͂
        dc->DrawFrameControl( rc, DFC_BUTTON, flg);

        // wiF̃uV쐬
        CBrush brush(m_SelectedColor);
        // ĕ`悷{^̉菬߂ɂ
        //rc.DeflateRect( 1, 1, 3, 2);
        // NbNĂԂ̏ꍇ
        if( lpDrawItemStruct->itemState & ODS_SELECTED )
        {
            // WEɂ炷
            rc.OffsetRect( 1, 1);
        }
        // w肵uVŎw͈͂hԂ
        dc->FillRect( rc, &brush);
        // WꎞIɊo
        m_innerRc = rc;

        // w肳ꂽ{^̃eLXg`悷
        CRect rrc( rc);
        CString strtxt;

        // 쐬Ɏw肳ꂽ{^̕\ʕ̎擾
        GetWindowText( strtxt);

        if( strtxt.IsEmpty() != TRUE )
        {
            // obNJ[͕ύXȂ
            dc->SetBkMode( TRANSPARENT);
            // ͈͂쐬
            CRect drc( rc);
            // 
            dc->DrawText( strtxt, &drc, DT_SINGLELINE | DT_CALCRECT);

            // ̍WvZ
            CPoint topleft(rc.left + ( rc.Width() - drc.Width()) /2,
              rc.top + ( rc.Height() - drc.Height())/2);

            UINT flg = 0;

            // {^gp̏ꍇ
            if( lpDrawItemStruct->itemState & ODS_DISABLED)
            {
                flg |= DSS_DISABLED;
            }
            // ĕ`
            dc->DrawState( topleft, CSize(0,0),strtxt, 
                     flg, TRUE, strtxt.GetLength(),(CBrush *)NULL);
        }

    }

    // tH[JXƂ
    // ̓tH[JXƂ́A
    // ANeBủ`悷
    if( (lpDrawItemStruct->itemState & ODS_FOCUS) ||
        (lpDrawItemStruct->itemAction & ODA_FOCUS) )
    {
        CRect frc = m_innerRc;
        // ̃VXeTCYVXe擾A
        // `悷WvZ
        frc.DeflateRect( 
               ::GetSystemMetrics( SM_CXBORDER), 
               ::GetSystemMetrics( SM_CYBORDER));
        // tH[JX̎lpg`悷
        dc->DrawFocusRect( frc);
    }

    // fBoCXReLXgɖ߂
    dc->RestoreDC( -1);
}

void CButtonEx::PreSubclassWindow() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	DWORD style = GetStyle();

    if( ( style & BS_OWNERDRAW ) != BS_OWNERDRAW)
    {
        ModifyStyle( 0, BS_OWNERDRAW);
    }

	CButton::PreSubclassWindow();
}

void CButtonEx::SetColor(COLORREF color)
{
	if(color==NULL)
		m_SelectedColor = m_DefaultColor;
	else
		m_SelectedColor = color;
    this->RedrawWindow();
}
